//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Runtime.InteropServices;

namespace UnmanagedException
{
	/// <summary>
	/// Podsumowanie dla UnmanagedExceptionTest.
	/// </summary>
	class NativeMethods
	{
		[DllImport("UnmanagedFault.dll")]
		public static extern int Custom();
		[DllImport("UnmanagedFault.dll")]
		public static extern int Fail();
		[DllImport("UnmanagedFault.dll")]
		public static extern int DivideByZero();
		[DllImport("UnmanagedFault.dll")]
		public static extern int MemoryAccess();
		[DllImport("UnmanagedFault.dll")]
		public static extern int Win32Error();
	}
	class UnmanagedExceptionTest
	{
		static void Main(string[] args)
		{
			Console.WriteLine("\nDzielenie przez zero\n");
			try
			{
				int result;
				result = NativeMethods.DivideByZero();
			}
			catch(Exception e)
			{
				Console.WriteLine(e.ToString());
			}
			Console.WriteLine("\nDostp do pamici\n");
			try
			{
				int result;
				result = NativeMethods.MemoryAccess();
			}
			catch(Exception e)
			{
				Console.WriteLine(e.ToString());
			}
			Console.WriteLine("\nBd\n");
			try
			{
				int result;
				result = NativeMethods.Fail();
			}
			catch(Exception e)
			{
				Console.WriteLine(e.ToString());
			}
			Console.WriteLine("\nWasny\n");
			try
			{
				int result;
				result = NativeMethods.Custom();
			}
			catch(Exception e)
			{
				Console.WriteLine(e.ToString());
			}
		}
	}
}
